// UIUC NetBitchDlg.h : header file
//

#if !defined(AFX_UIUCNETBITCHDLG_H__28E34086_BFBB_4313_8229_F70BF95EEE44__INCLUDED_)
#define AFX_UIUCNETBITCHDLG_H__28E34086_BFBB_4313_8229_F70BF95EEE44__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <winperf.h>
#include <pdh.h>
#include <math.h>
#include <pdhmsg.h>
#include "PerformanceCounter.h"
#include "GliderCtrl.h"

#define UPDATE_TIMER_ID				10
#define UPDATE_TIMER_INTERVAL		300
#define MOTION_TIMER_ID				20
#define MOTION_TIMER_INTERVAL		10


/////////////////////////////////////////////////////////////////////////////
// CUIUCNetBitchDlg dialog

class CMotionProperty
{
public:
	
	CMotionProperty()
	{
		dx = dy = left = top = right = bottom = Speed = Accel = HalfTravel = DistTraveled = 0;
		IsMoving = 0; 
	}

	CRect WindowPosition;
	int IsMoving;

	_inline void Setup(CRect &cur_rect, int dest_x, int dest_y, float accel, float speed)
	{
		float vector_len = 0;

		WindowPosition = cur_rect;

		left = (float) cur_rect.left;
		top = (float) cur_rect.top;
		right = (float) cur_rect.right;
		bottom = (float) cur_rect.bottom;

		DestRect.left = dest_x;
		DestRect.top = dest_y;
		DestRect.right = dest_x + cur_rect.Width();
		DestRect.bottom = dest_y + cur_rect.Height();

		dx = ((float) DestRect.left - left);
		dy = ((float) DestRect.top - top);
		vector_len = (float) sqrt((dx * dx) + (dy * dy));

		DistTraveled = 0;
		HalfTravel = (float) sqrt((dx * dx) + (dy * dy)) / 2.0f;

		dx = (dx / vector_len); 
		dy = (dy / vector_len); 

		Speed = speed;
		Accel = accel;

		IsMoving = 1;
	}

	_inline CRect& UpdatePosition()
	{
		if((DistTraveled < (HalfTravel * 2.0f)) && IsMoving)
		{
			float x_change = dx * Speed;
			float y_change = dy * Speed;

			left += x_change;
			right += x_change;
			top += y_change;
			bottom += y_change;

			WindowPosition.left = (int) left;
			WindowPosition.top = (int) top;
			WindowPosition.right = (int) right;
			WindowPosition.bottom = (int) bottom;

			DistTraveled += (float) sqrt((x_change * x_change) + (y_change * y_change));

			if(DistTraveled < (HalfTravel + Speed / 2))
			{
				Speed += Accel;
			}
			else
			{
				Speed -= Accel;
			}
		}
		else
		{
			IsMoving = 0;
		}
		
		return WindowPosition;
	}

private:

	CRect DestRect;
	float dx, dy;
	float left, top, right, bottom;
	float Accel, Speed;
	float HalfTravel, DistTraveled;
};


class CUIUCNetBitchDlg : public CDialog
{
// Construction
public:
	CUIUCNetBitchDlg(CWnd* pParent = NULL);	// standard constructor

	inline int ShowTaskBarButton(int state) 
	{ 
		if(state)
		{
			ModifyStyleEx(WS_EX_TOOLWINDOW, WS_EX_APPWINDOW); 
		}
		else 
		{
			ModifyStyleEx(WS_EX_APPWINDOW, WS_EX_TOOLWINDOW); 
		}

		//ShowWindow(SW_SHOW);

		return 1; 
	} 

	CPerformanceCounter PerfCounter;
	CMotionProperty MotionSystem;
	CGliderCtrl LeftGld, TopGld, RightGld, BottomGld;


	int ScreenWidth, ScreenHeight;
	int ScreenMidX, ScreenMidY;
	CRect WindowRect;
	CRect ClientRect;

// Dialog Data
	//{{AFX_DATA(CUIUCNetBitchDlg)
	enum { IDD = IDD_UIUCNETBITCH_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CUIUCNetBitchDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CUIUCNetBitchDlg)
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg void OnMove(int x, int y);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_UIUCNETBITCHDLG_H__28E34086_BFBB_4313_8229_F70BF95EEE44__INCLUDED_)
